import { getServerSession } from "next-auth";
import type { NextApiRequest, NextApiResponse } from "next";
import { authOptions } from "@/lib/authOptions";

export async function requireSession(
  req: NextApiRequest,
  res: NextApiResponse
) {
  const session = await getServerSession(req, res, authOptions);
  if (!session?.user?.id) {
    // quick visibility while debugging:
    console.log(
      "requireSession: no session; cookie header =",
      req.headers.cookie ?? "(none)"
    );
    res.status(401).json({ ok: false, error: "Unauthorized" });
    return null;
  }
  return session;
}
